
import { ResetPasswordRequestWidget } from './ResetPasswordRequestWidget.js';



export class AuthenticationWidget {
	
	
	tpl = `
		<div class="authentication-widget">
			<div class="popup-background"></div>
			
			<div class="popup-authentication">
				<h1>Aanmelden</h1>
				
				<form id="frmAuth">
					<table>
						<tr>
							<td>Gebruikersnaam</td>
							<td><input type="text" name="username" /></td>
						</tr>
						
						<tr>
							<td>Wachtwoord</td>
							<td><input type="password" name="password" /></td>
						</tr>
						<tr>
							<td>
							</td>
							<td>
								<label>
									<input type="checkbox" name="rememberme" /> Onthoud login
								</label>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<span id="auth-message" class="error"></span>
							</td>
						</tr>
						<tr>
							<td></td>
							<td align=right>
								<input type="button" name="auth" value="Aanmelden" [widget]="widget" onclick="this.widget.login();" />
							</td>
						</tr>
					</table>
				</form>
				
				<br/><br/>
				
				<a class="link-color1" [onclick]="widget.resetPassword_Click">{{_('Reset password')}}</a>
			</div>
		</div>
	`;
	
	
	eztpl = null;
	
	container = null;
	
	
	constructor() {
		
	}
	
	
	init(e) {
		if ($('.auth-container').length > 0)
			return;
		
		// ResetPasswordWidget shown? => don't show auth
		if ($('#reset-password-widget-content').length > 0)
			return;
		
		this.container = $('<div class="auth-container" />');
		$(document.body).append( this.container );
		this.render();
		
		$(this.container).find('input').on('keyup', (evt) => {
			if (evt.keyCode == 13) {	// enter
				this.login();
			}
		});
	}
	
	login() {
		showLoadingForm( '#frmAuth' );
		
		postUrl( '/service/auth.do', {
			a: 'auth',
			username: $('#frmAuth input[name=username]').val(),
			password: $('#frmAuth input[name=password]').val(),
			rememberme: $('#frmAuth input[name=rememberme]').prop('checked') ? 1 : 0,
		}).then(async (e) => {
			let json = await e.json();
			
			console.log('json resply', json);
			
			if (json.success) {
				window.location = window.location;
			}
			else {
				hideLoadingForm( '#frmAuth' );
				
				document.getElementById('auth-message').innerText = json.message;
				this.container.find('input[name=password]').focus();
			}
			
		});
		
	}
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		$('#frmAuth input[name=username]').focus();
	}
	
	
	
	resetPassword_Click() {
		let p = new ResetPasswordRequestWidget();
		p.init();
	}
	
}

